%{
This m-file belongs to the article 'The role of the electrolyte identity on
electrochemical CO2 conversion in the absence of mass transfer limitations'
Authors: Anne Sustronk (1,2) , Nieck E. Benes (1) , Guido Mul (2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Figures 3B and S3.

The next files are required to execute this file: ConstantCurrent.m, 
CalH2Data.txt, CalCOData.txt, CalFADataFeb22.txt, and CalErr.m

Note that the file location in line 32 of this file and in lines 46, 54, 59
of ConstantCurrent.m is to be added before execution

Brief overview of experimental conditions: Cu hollow fiber working
electrode, 0.5M K2SO4 in MilliQ water, with or without the addition of 
H2SO4, CO2 purged through fiber, chronopotentiometry at -5 mA and -50 mA

Version date m-file: Feb 24, 2023
%}

clear all, close all, clc

%% Size for plot (width, in cm)

size = 6;

%% File location and name
Location = {'...\K2SO4\CP CO2 flow'};

Folder1 = {'\-05 mA K2SO4 + 000 mM H2SO4 #1';
    '\-05 mA K2SO4 + 010 mM H2SO4 #1';
    '\-05 mA K2SO4 + 100 mM H2SO4 #1';
    '\-50 mA K2SO4 + 000 mM H2SO4 #1';
    '\-50 mA K2SO4 + 000 mM H2SO4 #2';
    '\-50 mA K2SO4 + 001 mM H2SO4 #1';
    '\-50 mA K2SO4 + 010 mM H2SO4 #1';
    '\-50 mA K2SO4 + 010 mM H2SO4 #2';
    '\-50 mA K2SO4 + 020 mM H2SO4 #1';
    '\-50 mA K2SO4 + 020 mM H2SO4 #2';
    '\-50 mA K2SO4 + 050 mM H2SO4 #1';
    '\-50 mA K2SO4 + 050 mM H2SO4 #2'};

% Data from potentiostat6
FileNameEC = {'\-05 mA K2SO4 + 000 mM H2SO4 CP.txt';
    '\-05 mA K2SO4 + 010 mM H2SO4 CP.txt';
    '\-05 mA K2SO4 + 100 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 000 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 000 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 001 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 010 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 010 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 020 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 020 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 050 mM H2SO4 CP.txt';
    '\-50 mA K2SO4 + 050 mM H2SO4 CP.txt'};

% Geometric area
Area(1:3,1) = 1.248*mean([0.146 0.149])*pi();
Area(4,1) = 1.444*mean([0.149 0.155])*pi();
Area(5,1) = 1.059*mean([0.148 0.146])*pi();
Area(6,1) = 1.143*mean([0.150 0.148])*pi();

Area(7,1) = Area(4,1);
Area(8,1) = Area(5,1);
Area(9,1) = Area(6,1);
Area(10,1) = Area(5,1);
Area(11,1) = Area(6,1);
Area(12,1) = Area(5,1);

% Error in geometric area
AreaErr(1:3,1) = 0.1*mean([0.146 0.149])*pi();
AreaErr(4,1) = 0.1*mean([0.149 0.155])*pi();
AreaErr(5,1) = 0.1*mean([0.148 0.146])*pi();
AreaErr(6,1) = 0.1*mean([0.150 0.148])*pi();

AreaErr(7,1) = AreaErr(4,1);
AreaErr(8,1) = AreaErr(5,1);
AreaErr(9,1) = AreaErr(6,1);
AreaErr(10,1) = AreaErr(5,1);
AreaErr(11,1) = AreaErr(6,1);
AreaErr(12,1) = AreaErr(5,1);

% Define Variable name
VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04'; 'Exp05'; 'Exp06'; 'Exp07'; 'Exp08'; 'Exp09'; 'Exp10'; 'Exp11';'Exp12'];

% File name for data file resitance data
RFileName = '\K2SO4 + H2SO4 CO2 flow Resistances.txt';

% Call ConstantCurrent.m, with option to calculate FA partial current
% density (y/n)
Data = ConstantCurrent(Location, Folder1, FileNameEC, Area, AreaErr, VarName, RFileName, 'y');

%% Plot data

% Time
time = [mean([Data.Exp04.t Data.Exp05.t],2), mean([Data.Exp09.t Data.Exp10.t],2),mean([Data.Exp07.t Data.Exp08.t],2), mean([Data.Exp11.t Data.Exp12.t],2)];

% Potential at working electrode corrected for the internal resistance
Ereal = [mean([Data.Exp04.Ereal(:,1) Data.Exp05.Ereal(:,1)],2), mean([Data.Exp09.Ereal(:,1) Data.Exp10.Ereal(:,1)],2), mean([Data.Exp07.Ereal(:,1) Data.Exp08.Ereal(:,1)],2),mean([Data.Exp11.Ereal(:,1) Data.Exp12.Ereal(:,1)],2)];

%% Plot Ereal vs time
fig = figure(1);
hold on
plot(mean([Data.Exp04.t Data.Exp05.t],2),mean([Data.Exp04.Ereal(:,1) Data.Exp05.Ereal(:,1)],2), '-b')
plot(mean([Data.Exp09.t Data.Exp10.t],2),mean([Data.Exp09.Ereal(:,1) Data.Exp10.Ereal(:,1)],2), '-r')
plot(mean([Data.Exp07.t Data.Exp08.t],2),mean([Data.Exp07.Ereal(:,1) Data.Exp08.Ereal(:,1)],2), '-m')
plot(mean([Data.Exp11.t Data.Exp12.t],2),mean([Data.Exp11.Ereal(:,1) Data.Exp12.Ereal(:,1)],2), '-k')
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([0 4000 -2.0 -0.8]);
ax.XTick = linspace(0,4000,5);
ax.YTick = linspace(-2.0, -0.8, 7);
ytickformat(ax,'%.1f')

% X and Y label and legend
xlabel('Time (s)')
ylabel('E_{real} (V vs Ag/AgCl)')
legend('0 mM', '20 mM ', '10 mM', '50 mM', 'Location', 'South','NumColumns',2)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];


%% Average IH2 vs H2SO4 concentration with errorbars
fig = figure(2);
hold on
errorbar(0,Data.IH2(4,1),Data.IH2(4,2) ,'*b')
errorbar(0,Data.IH2(5,1),Data.IH2(5,2) ,'ob')
errorbar(10,Data.IH2(7,1),Data.IH2(7,2) ,'*m')
errorbar(10,Data.IH2(8,1),Data.IH2(8,2) ,'om')
errorbar(20,Data.IH2(9,1),Data.IH2(9,2) ,'^r')
errorbar(20,Data.IH2(10,1),Data.IH2(10,2) ,'or')
errorbar(50,Data.IH2(11,1),Data.IH2(11,2) ,'^k')
errorbar(50,Data.IH2(12,1), Data.IH2(12,2) ,'ok')
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([0 60 -100 0]);
ax.XTick = linspace(0,60,7);
ax.YTick = linspace(-100, 0, 6);

% X and Y label and legend
xlabel('H_{2}SO_{4} concentration (mM)')
ylabel('I_{H_{2}} (mA)')
legend('0 mM', '0 mM', '10 mM', '10 mM','20 mM','20 mM', '50 mM','50 mM','Location', 'South', 'NumColumns',2)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [25 5 size*(4/3) size];

%% Average ICO vs H2SO4 concentration with errorbars
fig = figure(3);
hold on
errorbar(0,Data.ICO(4,1),Data.ICO(4,2) ,'*b')
errorbar(0,Data.ICO(5,1), Data.ICO(5,2) ,'ob')
errorbar(10,Data.ICO(7,1),Data.ICO(7,2) ,'*m')
errorbar(10,Data.ICO(8,1),Data.ICO(8,2) ,'om')
errorbar(20,Data.ICO(9,1),Data.ICO(9,2) ,'^r')
errorbar(20,Data.ICO(10,1),Data.ICO(10,2) ,'or')
errorbar(50,Data.ICO(11,1),Data.ICO(11,2) ,'^k')
errorbar(50,Data.ICO(12,1),Data.ICO(12,2) ,'ok')
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([0 60 -50 0]);
ax.XTick = linspace(0,60,7);
ax.YTick = linspace(-50, 0, 6);

% X and Y label and legend
xlabel('H_{2}SO_{4} concentration (mM)')
ylabel('I_{CO} (mA)')
legend('0 mM', '0 mM', '10 mM', '10 mM','20 mM','20 mM', '50 mM','50 mM','Location', 'South', 'NumColumns',2)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [15 5 size*(4/3) size];


%% Average IFA vs H2SO4 concentration with errorbars
fig = figure(4);
hold on
errorbar(0,Data.IFA(4,1),Data.IFA(4,2) ,'*b')
errorbar(0,Data.IFA(5,1),Data.IFA(5,2) ,'ob')
errorbar(10,Data.IFA(7,1),Data.IFA(7,2) ,'*m')
errorbar(10,Data.IFA(8,1),Data.IFA(8,2) ,'om')
errorbar(20,Data.IFA(9,1),Data.IFA(9,2) ,'^r')
errorbar(20,Data.IFA(10,1),Data.IFA(10,2) ,'or')
errorbar(50,Data.IFA(11,1),Data.IFA(11,2) ,'^k')
errorbar(50,Data.IFA(12,1),Data.IFA(12,2) ,'ok')
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([0 60 -50 0]);
ax.XTick = linspace(0,60,7);
ax.YTick = linspace(-50, 0, 6);

% X and Y label and legend
xlabel('H_{2}SO_{4} concentration (mM)')
ylabel('I_{FA} (mA)')
legend('0 mM', '0 mM', '10 mM', '10 mM','20 mM','20 mM', '50 mM','50 mM','Location', 'South', 'NumColumns',2)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [15 5 size*(4/3) size];